/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp.dialogs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.dialogs.StartupPreferencePage;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDEStartupPreferencePage
extends StartupPreferencePage
implements IWorkbenchPreferencePage {
    private Button refreshButton;
    private Button launchPromptButton;
    private Button exitPromptButton;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.startup_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createLaunchPromptPref(composite);
        this.createRefreshWorkspaceOnStartupPref(composite);
        this.createExitPromptPref(composite);
        Label space = new Label(composite, 0);
        space.setLayoutData((Object)new GridData());
        this.createEarlyStartupSelection(composite);
        return composite;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.launchPromptButton.setSelection(true);
        this.refreshButton.setSelection(store.getDefaultBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
        this.exitPromptButton.setSelection(store.getDefaultBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getIDEPreferenceStore();
        store.setValue("REFRESH_WORKSPACE_ON_STARTUP", this.refreshButton.getSelection());
        ChooseWorkspaceData.setShowDialogValue((boolean)this.launchPromptButton.getSelection());
        store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", this.exitPromptButton.getSelection());
        return super.performOk();
    }

    protected void createRefreshWorkspaceOnStartupPref(Composite composite) {
        this.refreshButton = new Button(composite, 32);
        this.refreshButton.setText(IDEWorkbenchMessages.StartupPreferencePage_refreshButton);
        this.refreshButton.setFont(composite.getFont());
        this.refreshButton.setSelection(this.getIDEPreferenceStore().getBoolean("REFRESH_WORKSPACE_ON_STARTUP"));
    }

    protected void createLaunchPromptPref(Composite composite) {
        this.launchPromptButton = new Button(composite, 32);
        this.launchPromptButton.setText(IDEWorkbenchMessages.StartupPreferencePage_launchPromptButton);
        this.launchPromptButton.setFont(composite.getFont());
        this.launchPromptButton.setSelection(ChooseWorkspaceData.getShowDialogValue());
    }

    protected void createExitPromptPref(Composite composite) {
        this.exitPromptButton = new Button(composite, 32);
        this.exitPromptButton.setText(IDEWorkbenchMessages.StartupPreferencePage_exitPromptButton);
        this.exitPromptButton.setFont(composite.getFont());
        this.exitPromptButton.setSelection(this.getIDEPreferenceStore().getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW"));
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }
}

